#!/usr/bin/env python3
import requests
import json
import hashlib
import hmac
import re
from Crypto.Cipher import AES
import binascii

# 本机校验，请求校验本机手机号接口demo

appId = "xxxx"  # 应用APPID
appKey = "xxx"  # 应用APPKEY
mobile = ""     # 校验手机号
url = 'https://api.253.com/open/flashsdk/mobile-validate'
token = 'xxxx'  # SDK返回token


def sign_params(data):
    message = ''
    if 'appId' in data:
        message += 'appId' + data['appId']
    if 'mobile' in data:
        message += 'mobile' + data['mobile']
    if 'token' in data:
        message += 'token' + data['token']
    signature = hmac.new(appKey.encode(), msg=message.encode(
    ), digestmod=hashlib.sha256).hexdigest()
    data['sign'] = signature


if __name__ == "__main__":
    formData = {
        'appId': appId,
        'mobile': mobile,
        'token': token,
        'sign': ''
    }
    sign_params(formData)
    r = requests.post(url, data=formData)
    print("本机号校验响应: %s" % r.json())
    resp = r.json()
    if resp["code"] == "200000":
        if encryptType == 0:  # 默认为AES加密
            data = resp['data']
            tradeNo = data['tradeNo']  # 交易流水号
            isVerify = data['isVerify']  # 手机号密文
            if "1" == isVerify:
                print('手机号码校验通过')
            else:
                print('手机号码校验不通过')
    else:
        print('本机校验失败')
