
//本机号校验服务端请求demo

var FormData = require('form-data');
var https = require('https');
var http = require('http');
var cryptoJS = require('crypto-js');
var md5=require('md5-node');


//应用对应的APPKEY
var appKey="xxxxxxxx";

//组装请求参数
var params={
	appId:"xxxxxxxx", //应用对应的闪验appId
	token:"xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx", //SDK返回的token
	mobile:"", //待校验的手机号码
	outId:"" //可以不传 ，如不传不用拼接到签名中
};

//拼接请求字符串
var content="";
var keys=Object.keys(params).sort();
for (i = 0; i < keys.length; i++) { 
    content += keys[i] + params[keys[i]];
}

//生成签名
var sign=cryptoJS.enc.Hex.stringify(cryptoJS.HmacSHA256(content, appKey));

//发送HTTP POST请求
var form = new FormData();
form.append('appId', params.appId);
form.append('token', params.token);
form.append('mobile', params.mobile);
form.append('outId', params.outId);//可不传
form.append('sign', sign);

var headers = form.getHeaders();//这个不能少
var request = https.request({
        method: 'post',
        host: 'api.253.com',
        path: "/open/flashsdk/mobile-validate",
        headers: headers
    },function(res){
        var str='';
        res.on('data',function(buffer){
            str+=buffer;//用字符串拼接
        });
        res.on('end',()=>{
            var result = JSON.parse(str);
            //result就是返回的结果
            console.log(result);
            if(result.code=="200000"){
                var isVerify=result.data.isVerify;
				if(isVerify=="1"){
					console.log("校验成功，是本机号码");
				}else{
					console.log("不是本机号码");
				}
            }
        });
    }
);
form.pipe(request);


